#ifndef C4D_SYMBOLS_H__
#define C4D_SYMBOLS_H__

enum
{
	// string table definitions
	IDS_START = 10000,

	IDS_ODISC,
	IDS_OSINGLEPOLY,
	IDS_OTORUS,
	IDS_OCUBE,
	IDS_OSPHERE,
	IDS_OPLATONIC,
	IDS_OFIGURE,
	IDS_OPYRAMID,
	IDS_OPLANE,
	IDS_OTUBE,
	IDS_OFRACTAL,
	IDS_OCONE,
	IDS_OCYLINDER,
	IDS_OCAPSULE,
	IDS_OOILTANK,
	IDS_ORELIEF,

	IDS_OSPLINECIRCLE,
	IDS_OSPLINEARC,
	IDS_OSPLINECISSOID,
	IDS_OSPLINECYCLOID,
	IDS_OSPLINEPROFILE,
	IDS_OSPLINECONTOUR,
	IDS_OSPLINEHELIX,
	IDS_OSPLINERECTANGLE,
	IDS_OSPLINESTAR,
	IDS_OSPLINECOGWHEEL,
	IDS_OSPLINEFLOWER,
	IDS_OSPLINEFORMULA,
	IDS_OSPLINETEXT,
	IDS_OSPLINE4SIDE,
	IDS_OSPLINENSIDE,

	IDS_OPARTICLEBASE,
	IDS_OGRAVITATION,
	IDS_OATTRACTOR,
	IDS_ODESTRUCTOR,
	IDS_ODEFLECTOR,
	IDS_OFRICTION,
	IDS_OROTATION,
	IDS_OTURBULENCE,
	IDS_OWIND,

	IDS_OHEADPHONE_DEPRECATED,
	IDS_OBACKGROUND,
	IDS_OFOREGROUND,
	IDS_OCONPLANE,
	IDS_OENVIRONMENT,
	IDS_OFLOOR,
	IDS_OSTAGE,
	IDS_OLOUDSPEAKER_DEPRECATED,
	IDS_OMICROPHONE,

	IDS_OBEND,
	IDS_OBULGE,
	IDS_OTWIST,
	IDS_OTAPER,
	IDS_OSHEAR,

	IDS_OEXPLOSION,
	IDS_OFORMULA,
	IDS_OMELT,
	IDS_OSHATTER,
	IDS_OWINDDEFORM,
	IDS_OWRAP,

	IDS_OPOLYREDUCTION,
	IDS_POLYREDUCTION,
	IDS_BOOLEOBJECT,

	IDS_VERTEX,
	IDS_HANDEFFECTOR,
	IDS_FOOTEFFECTOR,
	IDS_FIGURELEFT,
	IDS_FIGURERIGHT,
	IDS_HEADEFFECTOR,
	IDS_UPPERBODY,
	IDS_NECK,
	IDS_UPPERARM,
	IDS_LOWERARM,
	IDS_UPPERKNEE,
	IDS_LOWERKNEE,
	IDS_HAND,
	IDS_FOOT,
	IDS_HEAD,
	IDS_JOINT,
	IDS_TEXTCONTENT,

	IDS_PELVIS = 10256,

	// Operators
	// TODO: (Marc): figure out proper start index as compared to corresponding file in the 'object' module
	IDS_OPOLYREDUX_DEPRECATED,
	IDS_POLYREDUX_PREPROCESSING_REDUCTION,
	IDS_POLYREDUX_PREPROCESSING_TRIANGULATING,
	IDS_POLYREDUX_PREPROCESSING_OPTIMIZING,
	IDS_POLYREDUX_PREPROCESSING_INIT_COSTS,
	IDS_POLYREDUX_PREPROCESSING_INIT_STACK,
	IDS_POLYREDUX_PREPROCESSING_FINALIZE_STACK,
	IDS_OPOLYREDUX_GENERATOR,
	IDS_POLYREDUX_PREPROCESSING_COUNTING_EDGES,

	// spline to mesh strings.
	IDS_SPLINETOMESH_MESSAGE_BODY,
	IDS_SPLINETOMESH_MESSAGE_CAPS,

	// error message for melt
	IDS_MELT_ERROR,

	// Commands
	IDS_ALTERNATE_DELETE_COMPONENTS_COMMAND = 20000,
	IDS_REMOVE_NON_MANIFOLD = 20001,
	IDS_SELECT_ISLAND_FROM_EDGE = 20002,
	IDS_CUT_ISLAND_FROM_EDGE = 20003,
	IDS_UNWRAP_ISLAND_FROM_EDGE = 20004,
	IDS_MODELING_UVUNWRAP = 20005,
	IDS_UV_WELD = 20006,
	IDS_UV_WELD_RELAX = 20007,

	// Mirror Selection command and options
	IDS_MODELING_MIRROR_SELECTION = 20008,
	IDD_MODELING_MIRRORSELECTION = 20009,
	IDC_MIRRORSELECTION_MODE = 20010,
	IDC_MIRRORSELECTION_TOLERANCE = 20011,
	IDC_MIRRORSELECTION_SPACE = 20012,
	IDC_MIRRORSELECTION_PLANE = 20013,

	IDS_TOGGLEMODE = 20014,
	IDS_TOGGLEMODE_HELP = 20015,

	IDS_UNTRIANGULATE = 20016,
	IDS_UNTRIANGULATE_HELP = 20017,

	// UV Unwrap options
	IDD_MODELING_UVUNWRAP = 20018,
	IDC_UVUNWRAP_POLYGON = 20019,
	IDC_UVUNWRAP_PIN = 20020,
	IDC_UVUNWRAP_REALIGN = 20021,

	// Pin selection command strings
	IDS_ADDPINSELECTION_COMMAND = 20030,
	IDS_REMOVEPINSELECTION_COMMAND = 20031,
	IDS_CLEARPINSELECTION_COMMAND = 20032,

	// UV Weld and Relax options
	IDD_MODELING_UVWELDRELAX = 20040,
	IDC_UVWELDRELAX_PIN = 20041,
	IDC_UVWELDRELAX_REALIGN = 20042,
	IDC_UVWELDRELAX_POLYGON = 20043,

	// query messages
	IDS_PAINT_ENABLEMATERIAL = 21000,

	IDS_AUTOUV_STATUS = 22000,
	IDS_PACKUV_STATUS = 22001,
	IDS_UNWRAPPACKUV_STATUS = 22002,
	IDS_PACKUVGEOMETRIC_STATUS = 22003,
	IDS_PACKUVGEOMETRIC_FAIL_GENERAL = 22004,
	IDS_PACKUVGEOMETRIC_FAIL_EXCESSIVE_MIN_SPACING = 22005,
	IDS_PACKUVGEOMETRIC_FAIL_BAD_GEOMETRY = 22006,

	IDS_REMESHERCOMMAND = 23000,
	IDC_REMESH_DIALOG = 23001,
	IDC_REMESH_POLYGONTARGET= 23002,
	IDC_REMESH_KEEPOUTLINE= 23003,
	// End of symbol definition
	_DUMMY_ELEMENT_
};

#endif // C4D_SYMBOLS_H__
