CONTAINER Ocajoint
{
	NAME Ocajoint;
	INCLUDE Obase;
	INCLUDE Ofalloff_panel;
	
	GROUP Obaselist
	{
		PRIORITY ID_CA_JOINT_OBJECT_PRIORITY { ANIM OFF; }
		BOOL ID_CA_JOINT_OBJECT_ICONCOL { }
	}

	GROUP ID_OBJECTPROPERTIES
	{
		GROUP
		{
			COLUMNS 3;

			LONG ID_CA_JOINT_OBJECT_BONE_ALIGN
			{
				CYCLE
				{
					ID_CA_JOINT_OBJECT_BONE_ALIGN_NULL;
					ID_CA_JOINT_OBJECT_BONE_ALIGN_AXIS;
					ID_CA_JOINT_OBJECT_BONE_ALIGN_FROMPARENT;
					ID_CA_JOINT_OBJECT_BONE_ALIGN_TOCHILD;
				}
			}

			LONG ID_CA_JOINT_OBJECT_BONE_AXIS
			{
				CYCLE
				{
					ID_CA_JOINT_OBJECT_BONE_AXIS_X;
					ID_CA_JOINT_OBJECT_BONE_AXIS_Y;
					ID_CA_JOINT_OBJECT_BONE_AXIS_Z;
				}
			}

			BUTTON ID_CA_JOINT_OBJECT_ALIGN_AXIS { }

			REAL ID_CA_JOINT_OBJECT_LENGTH { FORBID_SCALING; UNIT METER; MIN 0.0; MAXSLIDER 100.0; CUSTOMGUI REALSLIDER; }
			STATICTEXT { JOINEND; }
			STATICTEXT { JOINEND; }
		}

		GROUP ID_CA_JOINT_OBJECT_BONE_GROUP
		{
			COLUMNS 2; DEFAULT 1;

			LONG ID_CA_JOINT_OBJECT_BONE_DISPLAY
			{
				CYCLE
				{
					ID_CA_JOINT_OBJECT_BONE_DISPLAY_NONE;
					ID_CA_JOINT_OBJECT_BONE_DISPLAY_STANDARD;
					ID_CA_JOINT_OBJECT_BONE_DISPLAY_BOX;
					ID_CA_JOINT_OBJECT_BONE_DISPLAY_LINE;
					ID_CA_JOINT_OBJECT_BONE_DISPLAY_STICK;
					ID_CA_JOINT_OBJECT_BONE_DISPLAY_POLYGON;
				}
			}

			LONG ID_CA_JOINT_OBJECT_BONE_SIZE_MODE
			{
				CYCLE
				{
					ID_CA_JOINT_OBJECT_BONE_SIZE_MODE_CUSTOM;
					ID_CA_JOINT_OBJECT_BONE_SIZE_MODE_LENGTH;
				}
			}

			REAL ID_CA_JOINT_OBJECT_BONE_SIZE { UNIT METER; MIN 0.0; MAXSLIDER 100.0; CUSTOMGUI REALSLIDER; }
			STATICTEXT { JOINEND; }
		}

		GROUP ID_CA_JOINT_OBJECT_JOINT_GROUP
		{
			COLUMNS 2; DEFAULT 1;

			LONG ID_CA_JOINT_OBJECT_JOINT_DISPLAY
			{
				CYCLE
				{
					ID_CA_JOINT_OBJECT_JOINT_DISPLAY_NONE;
					ID_CA_JOINT_OBJECT_JOINT_DISPLAY_AXIS;
					ID_CA_JOINT_OBJECT_JOINT_DISPLAY_SPHERE;
					ID_CA_JOINT_OBJECT_JOINT_DISPLAY_CIRCLE;
					ID_CA_JOINT_OBJECT_JOINT_DISPLAY_BALL;
				}
			}

			LONG ID_CA_JOINT_OBJECT_JOINT_SIZE_MODE
			{
				CYCLE
				{
					ID_CA_JOINT_OBJECT_JOINT_SIZE_MODE_CUSTOM;
					ID_CA_JOINT_OBJECT_JOINT_SIZE_MODE_LINK;
				}
			}

			REAL ID_CA_JOINT_OBJECT_JOINT_SIZE { UNIT METER; MIN 0.0; MAXSLIDER 100.0; CUSTOMGUI REALSLIDER; }
			STATICTEXT { JOINEND; }
		}
	}

	GROUP ID_CA_JOINT_OBJECT_IK_GROUP
	{
		REAL ID_CA_JOINT_OBJECT_JOINT_IK_WEIGHT { UNIT PERCENT; MIN 0.0; MAX 100.0; CUSTOMGUI REALSLIDER; }
		REAL ID_CA_JOINT_OBJECT_JOINT_IK_STRETCH { UNIT PERCENT; MIN 0.0; MAX 100.0; CUSTOMGUI REALSLIDER; }

		GROUP ID_CA_JOINT_OBJECT_PREFERRED_GROUP
		{
			GROUP
			{
				COLUMNS 2;

				BOOL ID_CA_JOINT_OBJECT_JOINT_IK_PREFERRED_ROT_LINK { }
				BUTTON ID_CA_JOINT_OBJECT_JOINT_IK_PREFERRED_SET { }
			}

			REAL ID_CA_JOINT_OBJECT_JOINT_IK_PREFERRED_ROT_WEIGHT { UNIT PERCENT; MIN 0.0; MAX 100.0; CUSTOMGUI REALSLIDER; }
			VECTOR	ID_CA_JOINT_OBJECT_JOINT_IK_PREFERRED_ROT { UNIT DEGREE; CUSTOMGUI SUBDESCRIPTION; }
		}

		GROUP ID_CA_JOINT_OBJECT_LIMITS_GROUP
		{
			DEFAULT 1;

			//BOOL	  ID_CA_JOINT_OBJECT_JOINT_IK_SHOW_LIMITS {}

			REAL	  ID_CA_JOINT_OBJECT_JOINT_IK_LIMITROT_STRENGTH { UNIT PERCENT; MIN 0.0; MAX 100.0; CUSTOMGUI REALSLIDER; }

			SEPARATOR { }

			GROUP
			{
				LAYOUTGROUP; COLUMNS 3;

				GROUP
				{
					BOOL	  ID_CA_JOINT_OBJECT_JOINT_IK_USE_ROT_H {}
					BOOL	  ID_CA_JOINT_OBJECT_JOINT_IK_USE_ROT_P {}
					BOOL	  ID_CA_JOINT_OBJECT_JOINT_IK_USE_ROT_B {}
				}
				GROUP
				{
					VECTOR	ID_CA_JOINT_OBJECT_JOINT_IK_MIN_ROT { UNIT DEGREE; MIN -180 -90 -180; MAX 180 90 180; CUSTOMGUI SUBDESCRIPTION; }
					//BUTTON  ID_CA_JOINT_OBJECT_JOINT_IK_SETMINROT {}
				}
				GROUP
				{
					VECTOR	ID_CA_JOINT_OBJECT_JOINT_IK_MAX_ROT { UNIT DEGREE; MIN -180 -90 -180; MAX 180 90 180; CUSTOMGUI SUBDESCRIPTION; }
					//BUTTON  ID_CA_JOINT_OBJECT_JOINT_IK_SETMAXROT {}
				}
			}
		}
	}

	GROUP ID_CA_JOINT_OBJECT_SYMMETRY_GROUP
	{
		COLUMNS 2;

		BOOL ID_CA_JOINT_OBJECT_MIRROR_ENABLE { }
		BOOL ID_CA_JOINT_OBJECT_BONE_HUB { }

		LINK ID_CA_JOINT_OBJECT_JOINT_MIRROR_LINK { ACCEPT { Obase; } }
		STATICTEXT { JOINEND; }

		LONG ID_CA_JOINT_OBJECT_MIRROR_ORIGIN
		{
			CYCLE
			{
				ID_CA_JOINT_OBJECT_MIRROR_ORIGIN_WORLD;
				ID_CA_JOINT_OBJECT_MIRROR_ORIGIN_ROOT;
				ID_CA_JOINT_OBJECT_MIRROR_ORIGIN_HUB;
				ID_CA_JOINT_OBJECT_MIRROR_ORIGIN_OBJECT;
			}
		}

		LONG ID_CA_JOINT_OBJECT_MIRROR_PLANE
		{
			CYCLE
			{
				ID_CA_JOINT_OBJECT_MIRROR_WORLD_XY;
				ID_CA_JOINT_OBJECT_MIRROR_WORLD_XZ;
				ID_CA_JOINT_OBJECT_MIRROR_WORLD_YZ;
				ID_CA_JOINT_OBJECT_MIRROR_LOCAL_XY;
				ID_CA_JOINT_OBJECT_MIRROR_LOCAL_XZ;
				ID_CA_JOINT_OBJECT_MIRROR_LOCAL_YZ;
			}
		}

		LINK ID_CA_JOINT_OBJECT_MIRROR_ORIGIN_LINK { ACCEPT { Obase; } }
		STATICTEXT { JOINEND; }

		REAL ID_CA_JOINT_OBJECT_MIRROR_COLOR_MIX { UNIT PERCENT; MIN 0.0; MAX 100.0; CUSTOMGUI REALSLIDER; }
		STATICTEXT { JOINEND; }

		COLOR ID_CA_JOINT_OBJECT_MIRROR_COLOR { }
		STATICTEXT { JOINEND; }
	}
	
	GROUP FALLOFF_GROUPFALLOFF
	{
	}
}
